# -*- coding: utf-8 -*-
"""r05.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/18FfhZOY8TZQqDTEkU6TfEu2PqqA7GwH8
"""

# Rozdział 5.

# importowanie bibliotek
import numpy as np
import matplotlib.pyplot as plt
import scipy.linalg
from scipy.linalg import toeplitz

# UWAGA: poniżej zdefiniowano globalne ustawienia związane z wyglądem rysunków,
# które wykorzystano do wygenerowania rysunków pokazanych w książce

from IPython import display
display.set_matplotlib_formats('svg') # Rysunki w formacie wektorowym
plt.rcParams.update({'font.size':14}) # Rozmiar czcionki

v = np.array([[1,2,3]]).T
w = np.array([[10,20]])
v + w

"""# Wizualizacja macierzy w postaci obrazków"""

A = np.random.randn(3,4)
B = np.random.randn(100,100)
C = -toeplitz(np.arange(8),np.arange(10))


fig,axs = plt.subplots(1,3,figsize=(10,3))

axs[0].imshow(A,cmap='gray')
axs[1].imshow(B,cmap='gray')
axs[2].imshow(C,cmap='gray')

for i in range(3): axs[i].axis('off')
plt.tight_layout()
plt.savefig('rys5.1.png',dpi=300)
plt.show()



"""# Slicing"""

# tworzenie macierzy
A = np.reshape(np.arange(1,10),(3,3))
print(A)

# pobieranie n-tego wiersza

print( A[1,:] )

# zauważ, że aby pobrać tylko jednej wiersz nie musimy korzystać z indeksów kolumn.
print( A[1] )
# może to być trochę mylące, dlatego nie zalecam tego podejścia

# pobieranie n-tej kolumny
print( A[:,1] )
# zauważ, że wynik jest wektorem wierszowym pomimo tego, że pobieram kolumnę macierzy

# wiele wierszy
A[0:2,:]

# wiele kolumn
A[:,1:]

# wyodrębnianie podmacierzy (wiele kolumn i wiele wierszy)

# chcę wyodrębnić z A podmacierz. Oto A:
# [[1 2 3]
#  [4 5 6]
#  [7 8 9]]

# interesują mnie wiersze 0-1 oraz kolumny 0-1, tj.:
# [[1 2]
#  [4 5]]


# wydaje się, że poniższy kod powinien zadziałać...
print( A[0:2,1:2] )
print(' ')

# ale nie działa (przypominam, że zapis x:y:z oznacza wycinek od x do y-1 z krokiem z)
print( A[0:2:1,0:2:1] )

# przykład z książki

# macierz
A = np.arange(60).reshape(6,10)

# i jej fragment
sub = A[1:4:1,0:5:1]


# print them out
print('Oryginalna macierz:\n')
print(A)

print('\n\nPodmacierz:\n')
print(sub)



"""# Niektóre specjalne rodzaje macierzy"""

# macierz kwadratowa
M1 = np.random.permutation(16).reshape(4,4)

# macierz trójkątna górna
M2 = np.triu(np.random.randint(10,20,(3,3)))

# macierz trójkątna dolna
M3 = np.tril(np.random.randint(8,16,(3,5)))

# macierz diagonalna
M4 = np.diag( np.random.randint(0,6,size=8) )

# macierz jednostkowa
M5 = np.eye(4,dtype=int)

# macierz zerowa
M6 = np.zeros((4,5),dtype=int)

matrices  = [ M1,M2,M3,M4,M5,M6 ]
matLabels = [ 'Kwadratowa','Trójkątna górna','Trójkątna dolna','Diagonalna','Jednostkowa','Zerowa'  ]


_,axs = plt.subplots(2,3,figsize=(12,6))
axs = axs.flatten()

for mi,M in enumerate(matrices):
  axs[mi].imshow(M,cmap='gray',origin='upper',
                 vmin=np.min(M),vmax=np.max(M))
  axs[mi].set(xticks=[],yticks=[])
  axs[mi].set_title(matLabels[mi])

  # text labels
  for (j,i),num in np.ndenumerate(M):
    axs[mi].text(i,j,num,color=[.8,.8,.8],ha='center',va='center',fontweight='bold')



plt.savefig('rys5.2.png',dpi=300)
plt.tight_layout()
plt.show()



# rozmiar macierzy (w Pythonie nazywany kształtem, ang. shape)
Mrows = 4 # liczba wierszy (shape 0)
Ncols = 6 # liczba kolumn (shape 1)

A = np.random.randn(Mrows,Ncols)
np.round(A,3)

# macierze trójkątne

M = 4
N = 6
A = np.random.randn(M,N)

print('Macierz trójkątna górna:\n')
print(np.triu(A))

print('\n\nMacierz trójkątna dolna:\n')
print(np.tril(A))

# macierze diagonalne

A = np.random.randn(5,5)
d = np.diag(A)
print('Po przekazaniu do np.diag() macierzy:\n',d)

v = np.arange(1,6)
D = np.diag(v)
print('\n\nPo przekazaniu do np.diag() wektora:\n',D)

# macierze jednostkowe

n = 4
I = np.eye(n)
print(f'Macierz jednostkowa o wymiarach {n}x{n}:\n',I)

# macierze zerowe

# Uwaga: Inaczej niż w przyadku np.random.randn() kształt macierzy podaje się w jednym parametrze
n = 4
m = 5
I = np.zeros((n,m))
print(f'Macierz zerowa o wymiarach {n}x{m}:\n',I)



"""# Dodawanie macierzy"""

A = np.array([  [2,3,4],
                [1,2,4] ])

B = np.array([  [ 0, 3,1],
                [-1,-4,2] ])

print(A+B)



"""# Przesuwanie macierzy"""

# To nie jest przesuwanie macierzy!
3 + np.eye(2)

# To jest przesuwanie macierzy:

# macierz
A = np.array([ [4,5, 1],
               [0,1,11],
               [4,9, 7]  ])

# skalar
s = 6

print('Oryginalna macierz:')
print(A), print(' ')

print('Dodawanie skalara z użyciem broadcastingu:')
print(A + s), print(' ')

print('Przesuwanie macierzy:')
print( A + s*np.eye(len(A)) )



"""# Mnożenie przez skalar"""

print(A), print(' ')
print(s*A)



"""# Iloczyn Hadamarda"""

A = np.random.randn(3,4)
B = np.random.randn(3,4)
A*B # iloczyn Hadamarda
np.multiply(A,B) # również iloczyn Hadamarda

A@B # To nie jest iloczyn Hadamarda, ten fragment nie zadziała

"""# "Standardowe" mnożenie macierzy"""

A = np.random.randn(3,6)
B = np.random.randn(6,4)
C = np.random.randn(6,4)

print( (A@B).shape )
print( np.dot(A,B).shape )
print( (B@C).shape )
print( (A@C).shape )

# iloczyn Hadamarda:
print( np.multiply(B,C) ), print(' ')

# mnożenie macierzy
print( np.dot(B,C.T) )

# przykład:
# np.dot(B,C.T)-B@C.T



"""# Geometryczna interpretacja mnożenia macierz-wektor"""

M  = np.array([ [2,3],[2,1] ])
x  = np.array([ [1,1.5] ]).T
Mx = M@x


plt.figure(figsize=(6,6))

plt.plot([0,x[0,0]],[0,x[1,0]],'k',linewidth=4,label='x')
plt.plot([0,Mx[0,0]],[0,Mx[1,0]],'--',linewidth=3,color=[.7,.7,.7],label='Mx')
plt.xlim([-7,7])
plt.ylim([-7,7])
plt.legend()
plt.grid()
plt.savefig('rys5.5a.png',dpi=300)
plt.show()

M  = np.array([ [2,3],[2,1] ])
v  = np.array([ [1.5,1] ]).T
Mv = M@v


plt.figure(figsize=(6,6))

plt.plot([0,v[0,0]],[0,v[1,0]],'k',linewidth=4,label='v')
plt.plot([0,Mv[0,0]],[0,Mv[1,0]],'--',linewidth=3,color=[.7,.7,.7],label='Mv')
plt.xlim([-7,7])
plt.ylim([-7,7])
plt.legend()
plt.grid()
plt.savefig('rys5.5b.png',dpi=300)
plt.show()



"""# Transpozycja"""

A = np.array([ [3,4,5],[1,2,3] ])

A_T1 = A.T # metoda
A_T2 = np.transpose(A) # funkcja

# podwójna transpozycja
A_TT = A_T1.T

print( A_T1 ), print(' ')
print( A_T2 ), print(' ')
print( A_TT )





"""# Ćwiczenie 1."""

A = np.arange(12).reshape(3,4)
print(A)

ri = 1
ci = 3

print(f'Element na pozycji ({ri+1},{ci+1}) to {A[ri,ci]}.')

"""# Ćwiczenie 2."""

C = np.arange(100).reshape((10,10))

C_1 = C[0:5:1,0:5:1]

print(C), print(' ')
print(C_1)

# wizualizacja wyniku

_,axs = plt.subplots(1,2,figsize=(10,5))

axs[0].imshow(C,cmap='gray',origin='upper',vmin=0,vmax=np.max(C))
axs[0].plot([4.5,4.5],[-.5,9.5],'w--')
axs[0].plot([-.5,9.5],[4.5,4.5],'w--')
axs[0].set_title('Oryginalna macierz')
# text labels
for (j,i),num in np.ndenumerate(C):
  axs[0].text(i,j,num,color=[.8,.8,.8],ha='center',va='center')


axs[1].imshow(C_1,cmap='gray',origin='upper',vmin=0,vmax=np.max(C))
axs[1].set_title('Podmacierz')
# text labels
for (j,i),num in np.ndenumerate(C_1):
  axs[1].text(i,j,num,color=[.8,.8,.8],ha='center',va='center')


plt.savefig('rys5.6.png',dpi=300)
plt.show()

"""# Ćwiczenie 3.

"""

# pobieram bloki
C_1 = C[0:5:1,0:5:1]
C_2 = C[0:5:1,5:10:1]
C_3 = C[5:10:1,0:5:1]
C_4 = C[5:10:1,5:10:1]

# zmieniam ich kolejność
newMatrix = np.vstack( (np.hstack((C_4,C_3)),
                        np.hstack((C_2,C_1))) )


# wizualizacja wyniku
_,axs = plt.subplots(1,2,figsize=(10,5))

axs[0].imshow(C,cmap='gray',origin='upper',vmin=0,vmax=np.max(C))
axs[0].plot([4.5,4.5],[-.5,9.5],'w--')
axs[0].plot([-.5,9.5],[4.5,4.5],'w--')
axs[0].set_title('Oryginalna macierz')
# text labels
for (j,i),num in np.ndenumerate(C):
  axs[0].text(i,j,num,color=[.8,.8,.8],ha='center',va='center')


axs[1].imshow(newMatrix,cmap='gray',origin='upper',vmin=0,vmax=np.max(C))
axs[1].plot([4.5,4.5],[-.5,9.5],'w--')
axs[1].plot([-.5,9.5],[4.5,4.5],'w--')
axs[1].set_title('Macierz po zmianie\nkolejności bloków')
# text labels
for (j,i),num in np.ndenumerate(newMatrix):
  axs[1].text(i,j,num,color=[.8,.8,.8],ha='center',va='center')

plt.savefig('rys5.7.png',dpi=300)
plt.show()

"""# Ćwiczenie 4."""

def addMatrices(A,B):

  if A.shape != B.shape:
    raise('Macierze muszą mięć te same wymiary!')

  C = np.zeros(A.shape)

  for i in range(A.shape[0]):
    for j in range(A.shape[1]):
      C[i,j] = A[i,j] + B[i,j]

  return C


M1 = np.zeros((6,4))
M2 = np.ones((6,4))

addMatrices(M1,M2)

"""# Ćwiczenie 5."""

A = np.random.randn(3,4)
B = np.random.randn(3,4)
s = np.random.randn()

expr1 = s*(A+B)
expr2 = s*A + s*B
expr3 = A*s + B*s


# istnieje kilka sposobów sprawdzenia, czy wszystkie trzy formuły dają ten sam wynik
# poniżej założyłem, że jeżeli x=y=z, to 2x-y-z=0

# wyświetlam wyniki i zaokrąglam je do ośmiu miejsc po przecinku
print(np.round(2*expr1 - expr2 - expr3,8))



"""# Ćwiczenie 6."""

m = 4
n = 6
A = np.random.randn(m,n);
B = np.random.randn(n,m)

C1 = np.zeros((m,m))
for rowi in range(m):
  for coli in range(m):
    C1[rowi,coli] = np.dot( A[rowi,:],B[:,coli] )



C2 = A@B

# porównanie wyników (korzystam z isclose(); wynikiem powinna być macierz zawierająca jedynie wartości True)
np.isclose( C1,C2 )



"""# Ćwiczenie 7."""

L = np.random.randn(2,6)
I = np.random.randn(6,3)
V = np.random.randn(3,5)
E = np.random.randn(5,2)

res1 = ( L@I@V@E ).T
# res2 = L.T @ I.T @ V.T @ E.T
res3 = E.T @ V.T @ I.T @ L.T

print(res1-res3)

"""# Ćwiczenie 8."""

def isMatrixSymmetric(S):

  # obliczam różnice między macierzą i jej transpozycją
  D = S-S.T

  # obliczam sumę kwadratów błędów
  sse = np.sum(D**2)

  # i porównuję ją z ustalonym progiem
  return sse<10**-15

# Uwaga: to nie jedyny sposób rozwiązania tego problemu, możesz też wykorzystać funkcje np.all() lub np.isclose()

A = np.random.randn(4,4)
AtA = A.T@A

print(isMatrixSymmetric(A))
print(isMatrixSymmetric(AtA))



"""# Ćwiczenie 9."""

A = np.random.randn(4,4)
AtA = (A + A.T) / 2 # metoda addytywna!

print(isMatrixSymmetric(A))
print(isMatrixSymmetric(AtA))



"""# Ćwiczenie 10."""

import plotly.graph_objects as go

A = np.array( [ [3,0],
                [5,2],
                [1,2] ] )


# A = np.array( [ [3,1.5],
#                 [5,2.5],
#                 [1, .5] ] )


xlim = [-4,4]
scalars = np.random.uniform(low=xlim[0],high=xlim[1],size=(100,2))

# tworzę losowe punktu
points = np.zeros((100,3))
for i in range(len(scalars)):
  points[i,:] = A@scalars[i]

# wyświetlam punkty na rysunku
fig = go.Figure( data=[go.Scatter3d(x=points[:,0], y=points[:,1], z=points[:,2], mode='markers')])
fig.show()



"""# Ćwiczenie 11."""

n = 4

O = np.ones((n,n))
D = np.diag(np.arange(1,n+1)**2)
S = np.sqrt(D)

pre = D@O
pst = O@D

both = S@O@S



print('Macierz jedynek:')
print(O), print(' ')

print('Pierwsza macierz diagonalna:')
print(D), print(' ')

print('Druga macierz diagonalna:')
print(S), print(' ')



print('Wynik lewostronnego mnożenia przez macierz diagonalną:')
print(pre), print(' ')

print('Wynik prawostronnego mnożenia przez macierz diagonalną:')
print(pst), print(' ')

print('Wynik mnożenia macierzy jedynek przez macierz diagonalną z obu stron:')
print(both)



"""# Ćwiczenie 12."""

N = 5
D1 = np.diag( np.random.randn(N) )
D2 = np.diag( np.random.randn(N) )

hadamard = D1*D2
standard = D1@D2

hadamard - standard



